/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.util;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;

public final class GameUtils {
    private GameUtils() {
    }

    public static RecipeManager getRecipeManager(@Nullable Level level) {
        if (level != null && level.m_142572_() != null) {
            return level.m_142572_().m_129894_();
        }
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            return ServerLifecycleHooks.getCurrentServer().m_129894_();
        }
        assert (Minecraft.m_91087_().f_91073_ != null);
        return Minecraft.m_91087_().f_91073_.m_7465_();
    }

    public static void dropItem(Level level, BlockPos pos, ItemStack stack, boolean offset) {
        GameUtils.spawnEntity(level, (Entity)new ItemEntity(level, (double)pos.m_123341_() + (offset ? 0.5 : 0.0), (double)pos.m_123342_() + (offset ? 0.5 : 0.0), (double)pos.m_123343_() + (offset ? 0.5 : 0.0), stack));
    }

    public static void spawnEntity(Level level, Entity entity) {
        level.m_7967_(entity);
    }

    public static void playSound(@Nullable Level level, BlockPos pos, SoundEvent sound) {
        if (level == null) {
            return;
        }
        level.m_5594_(null, pos, sound, SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    public static void renderCount(PoseStack stack, String text, int x, int y) {
        GameUtils.renderText(stack, text, ANCHOR.BOTTOM_RIGHT, x + 2, y + 2, 1.0f, 0xFFFFFF);
    }

    public static boolean isWithinBounds(double mX, double mY, int x, int y, int width, int height) {
        return mX >= (double)x && mX <= (double)(x + width) && mY >= (double)y && mY <= (double)(y + height);
    }

    public static void renderText(PoseStack stack, String text, ANCHOR anchor, int x, int y, float scale, int color) {
        stack.m_85836_();
        stack.m_85837_((double)x, (double)y, 200.0);
        stack.m_85841_(scale, scale, 1.0f);
        int xOffset = 0;
        int yOffset = 0;
        Font font = Minecraft.m_91087_().f_91062_;
        int width = font.m_92895_(text);
        Objects.requireNonNull(font);
        int height = 9;
        switch (anchor) {
            case TOP_LEFT: {
                break;
            }
            case TOP_RIGHT: {
                xOffset -= width;
                break;
            }
            case BOTTOM_LEFT: {
                yOffset -= height;
                break;
            }
            case BOTTOM_RIGHT: {
                xOffset -= width;
                yOffset -= height;
            }
        }
        font.m_92750_(stack, text, (float)xOffset, (float)yOffset, color);
        stack.m_85849_();
    }

    public static enum ANCHOR {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

